# Log Analysis Security Scanner

## Overview
The Log Analysis Security Scanner is a powerful tool that analyzes system and application logs to identify potential security threats, unauthorized access attempts, and other suspicious activities. It supports multiple log formats and provides detailed reports with security recommendations.

## Features

### Basic Version
* Supports common log formats (syslog, Apache, Nginx)
* Detects suspicious activities:
  * Failed login attempts
  * Brute force attacks
  * Unauthorized access attempts
  * SQL injection attempts
  * XSS attack patterns
* Identifies error patterns that could indicate vulnerabilities
* Generates reports in text and CSV formats
* Basic IP reputation checking
* Simple command-line interface

### Advanced Version
* Machine learning-based anomaly detection
* Enhanced IP reputation checking with threat intelligence integration
* Geographic location mapping of suspicious IPs
* Advanced visualization with interactive charts and heatmaps
* HTML report generation with detailed threat analysis
* Attack pattern recognition with MITRE ATT&CK framework mapping
* Cross-log correlation for advanced threat hunting
* Real-time monitoring capabilities
* Customizable alerting mechanisms (email, Slack, webhooks)
* Hadoop/Spark integration for large-scale log analysis

## Requirements
- Python 3.7+
- Required Python packages (install via `pip install -r requirements.txt`):
  - pandas
  - numpy
  - scikit-learn (advanced version)
  - matplotlib (advanced version)
  - geoip2 (advanced version)
  - requests
  - beautifulsoup4
  - pycryptodome

## Installation

1. Clone or download the script
2. Install required dependencies:
   ```
   pip install -r requirements.txt
   ```
3. For the advanced version, download GeoIP database:
   ```
   mkdir -p data
   wget https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key=YOUR_LICENSE_KEY -O data/GeoLite2-City.mmdb
   ```

## Usage

### Basic Version
```bash
python log_security_scanner.py \
  --log=/var/log/auth.log \
  --format=syslog \
  --output=security_report.txt \
  --verbose
```

### Multiple Log Files
```bash
python log_security_scanner.py \
  --log=/var/log/auth.log,/var/log/apache2/access.log \
  --format=auto \
  --output=security_report.csv \
  --csv
```

### Advanced Version
```bash
python log_security_scanner_advanced.py \
  --config=scanner_config.json \
  --ml-detection \
  --geo-mapping \
  --visualize \
  --html-report \
  --email-alerts
```

## Configuration
For the advanced version, create a `scanner_config.json` file with the following structure:
```json
{
  "log_sources": [
    {
      "path": "/var/log/auth.log",
      "format": "syslog",
      "importance": "high"
    },
    {
      "path": "/var/log/apache2/access.log",
      "format": "apache",
      "importance": "medium"
    },
    {
      "path": "/var/log/nginx/error.log",
      "format": "nginx",
      "importance": "high"
    }
  ],
  "detection": {
    "brute_force": {
      "enabled": true,
      "threshold": 5,
      "window_minutes": 10
    },
    "sql_injection": {
      "enabled": true,
      "patterns": ["union select", "information_schema", "--", "1=1"]
    },
    "xss": {
      "enabled": true,
      "patterns": ["<script>", "alert(", "onerror=", "javascript:"]
    },
    "anomaly_detection": {
      "enabled": true,
      "training_days": 7,
      "sensitivity": "medium"
    }
  },
  "reporting": {
    "formats": ["html", "csv", "json"],
    "output_dir": "/var/reports/security",
    "include_raw_events": false,
    "max_events_per_category": 100
  },
  "alerts": {
    "email": {
      "enabled": true,
      "recipients": ["security@example.com", "admin@example.com"],
      "severity_threshold": "medium",
      "smtp_server": "smtp.gmail.com",
      "smtp_port": 587,
      "smtp_user": "alerts@example.com",
      "smtp_password_env": "EMAIL_PASSWORD"
    },
    "slack": {
      "enabled": true,
      "webhook_url": "https://hooks.slack.com/services/XXXX/YYYY/ZZZZ",
      "channel": "#security-alerts",
      "severity_threshold": "high"
    }
  },
  "ip_reputation": {
    "enabled": true,
    "providers": ["abuseipdb", "virustotal", "emergingthreats"],
    "cache_hours": 24
  },
  "geo_mapping": {
    "enabled": true,
    "db_path": "data/GeoLite2-City.mmdb",
    "suspicious_countries": ["CN", "RU", "IR", "KP"]
  }
}
```

## Scheduling Regular Scans

### Linux/Unix (Cron)
Add a cron job to run the security scanner regularly:
```
# Run security scan every hour
0 * * * * /path/to/python /path/to/log_security_scanner.py --config=/path/to/scanner_config.json
```

### Windows (Task Scheduler)
1. Open Task Scheduler
2. Create a new Basic Task
3. Set the trigger to run hourly
4. Set the action to start a program
5. Program/script: `C:\Path\to\python.exe`
6. Arguments: `C:\Path\to\log_security_scanner.py --config=C:\Path\to\scanner_config.json`

## Interpreting Results
The security scanner classifies findings into several categories:

* **Critical**: Immediate action required, high confidence of compromise
* **High**: Significant security concern, investigate promptly
* **Medium**: Potential security issue, further investigation recommended
* **Low**: Suspicious activity, monitor for escalation
* **Info**: Informational findings, no immediate action required

Each finding includes:
- Timestamp and event details
- Affected system/application
- Threat type and category
- Potential impact
- Recommended actions
- Supporting evidence

## Best Practices
- Run the scanner regularly (at least daily)
- Configure email alerts for critical and high severity findings
- Review the full reports weekly
- Integrate with your SIEM system (advanced version)
- Update patterns and rules regularly
- Use machine learning detection for identifying novel threats
- Cross-reference findings with threat intelligence
- Maintain an up-to-date GeoIP database

## Support
For issues or questions about this tool, please contact support@yourcompany.com or open an issue on GitHub.

## License
MIT License - Feel free to modify and distribute this tool according to your needs.
