# GCP Cost Monitoring Tool

## Overview
The GCP Cost Monitoring Tool helps you track and optimize your Google Cloud Platform spending. It monitors costs across projects and services, sends alerts when spending exceeds thresholds, and provides recommendations for cost optimization.

## Features

### Basic Version
* Daily cost monitoring for GCP projects
* Email alerts when costs exceed thresholds
* Simple setup with minimal configuration
* Support for both project-level and billing account-level monitoring

### Advanced Version
* Daily and trend-based cost monitoring
* Service-specific thresholds and alerts
* Cost forecasting and anomaly detection
* Visualization of cost trends and breakdowns
* Export to BigQuery for custom analysis
* Storage of reports in Cloud Storage
* Customizable recommendations based on spending patterns

## Requirements
- Python 3.7+
- Google Cloud SDK installed and configured
- Required Python packages (install via `pip install -r requirements.txt`):
  - google-cloud-billing
  - google-cloud-bigquery (advanced version)
  - google-cloud-storage (advanced version)
  - pandas
  - matplotlib (advanced version)
  - scikit-learn (advanced version for forecasting)

## Installation

1. Clone or download the script
2. Install required dependencies:
   ```
   pip install -r requirements.txt
   ```
3. Configure GCP authentication:
   ```
   gcloud auth application-default login
   ```
4. Make sure your service account has appropriate permissions:
   - Billing Account Viewer
   - BigQuery Data Editor (advanced version)
   - Storage Object Admin (advanced version)

## Usage

### Basic Version
```bash
python gcp_cost_monitor.py \
  --project_id=your-project-id \
  --billing_account=XXXXXX-XXXXXX-XXXXXX \
  --threshold=100 \
  --email=your-email@example.com \
  --smtp_server=smtp.gmail.com \
  --smtp_user=your-email@example.com \
  --smtp_password=your-password
```

### Advanced Version
```bash
python gcp_cost_monitor_advanced.py \
  --project_id=your-project-id \
  --billing_account=XXXXXX-XXXXXX-XXXXXX \
  --config=cost_config.json \
  --forecast \
  --days=60 \
  --email=your-email@example.com \
  --export_to_bq \
  --bq_dataset=cost_monitoring \
  --bq_table=daily_costs \
  --store_reports \
  --gcs_bucket=cost-reports-bucket
```

## Configuration
For the advanced version, create a `cost_config.json` file with the following structure:
```json
{
  "thresholds": {
    "global": 500,
    "services": {
      "Compute Engine": 300,
      "Cloud Storage": 150,
      "BigQuery": 200
    }
  },
  "notifications": {
    "email": ["email1@example.com", "email2@example.com"],
    "channels": ["email", "slack"],
    "slack_webhook": "https://hooks.slack.com/services/XXXX/YYYY/ZZZZ"
  },
  "reports": {
    "frequency": "daily",
    "format": ["html", "csv"],
    "store_in_gcs": true,
    "gcs_bucket": "cost-reports-bucket"
  }
}
```

## Best Practices
- Set appropriate thresholds based on your typical usage
- Configure service-specific thresholds for better visibility
- Use the forecasting feature to anticipate cost spikes
- Review cost reports regularly and implement recommendations
- For larger organizations, export data to BigQuery for custom dashboards

## Support
For issues or questions about this tool, please contact support@yourcompany.com or open an issue on GitHub.

## License
MIT License - Feel free to modify and distribute this tool according to your needs.
