# Cloud Backup Automation Tool

## Overview

The Cloud Backup Automation Tool provides a reliable, secure, and efficient solution for backing up critical files and databases to Google Cloud Storage. This script can be scheduled to run automatically, ensuring your data is consistently protected with minimal manual intervention.

## Features

### Basic Version

* Automated backup of files and directories to GCP Cloud Storage
* Configurable retention policy (keep last N backups)
* Compression to save storage space
* Basic encryption of sensitive data
* Email notifications on completion/failure
* Support for inclusion/exclusion patterns

### Advanced Version

* Support for multiple backup destinations (GCP, AWS, Azure)
* Database backup support (MySQL, PostgreSQL, MongoDB, SQL Server)
* Point-in-time recovery options
* Incremental backup capability
* Strong AES-256 encryption with key management
* Backup verification and integrity checking
* Detailed logging and reporting
* Bandwidth throttling to minimize network impact
* Scheduled backups with customizable frequency
* Restore capability with GUI interface

## Requirements

* Python 3.7+

* Google Cloud SDK installed and configured
* Required Python packages (install via `pip install -r requirements.txt`):
  * google-cloud-storage
  * cryptography
  * tqdm
  * schedule (advanced version)
  * pymongo (advanced version, for MongoDB backups)
  * psycopg2 (advanced version, for PostgreSQL backups)
  * mysql-connector-python (advanced version, for MySQL backups)
  * pyodbc (advanced version, for SQL Server backups)

## Installation

1. Clone or download the script
2. Install required dependencies:

   ```bash
   pip install -r requirements.txt
   ```

3. Configure GCP authentication:

   ```bash
   gcloud auth application-default login
   ```

4. Make sure your service account has appropriate permissions:
   * Storage Object Admin

## Usage

### Basic Version_v1

```bash
python cloud_backup.py \
  --source=/path/to/backup \
  --bucket=your-backup-bucket \
  --prefix=daily-backup \
  --retention=7 \
  --encrypt \
  --exclude="*.tmp,*.log" \
  --email=your-email@example.com
```

### Advanced Version_v1

```bash
python cloud_backup_advanced.py \
  --config=backup_config.json \
  --mode=incremental \
  --verify \
  --throttle=5 \
  --notification=email,slack
```

## Configuration

For the advanced version, create a `backup_config.json` file with the following structure:

```json
{
  "sources": [
    {
      "type": "filesystem",
      "path": "/path/to/critical/files",
      "include": ["*.docx", "*.xlsx", "*.pdf"],
      "exclude": ["*.tmp", "*.log", "node_modules/"]
    },
    {
      "type": "database",
      "engine": "postgresql",
      "host": "localhost",
      "port": 5432,
      "database": "production_db",
      "username": "backup_user",
      "password_env": "DB_BACKUP_PASSWORD"
    }
  ],
  "destinations": [
    {
      "type": "gcp",
      "bucket": "company-backups",
      "prefix": "daily/",
      "project_id": "your-project-id"
    },
    {
      "type": "local",
      "path": "/mnt/backup_drive/backups"
    }
  ],
  "encryption": {
    "enabled": true,
    "method": "AES256",
    "key_management": "kms",
    "kms_key": "projects/your-project/locations/global/keyRings/backup-keys/cryptoKeys/backup-key"
  },
  "schedule": {
    "full": "0 0 * * 0",  // Weekly full backup (Sunday at midnight)
    "incremental": "0 0 * * 1-6"  // Daily incremental backup (Monday-Saturday at midnight)
  },
  "retention": {
    "full": 4,  // Keep last 4 full backups
    "incremental": 7,  // Keep last 7 incremental backups
    "total_size_limit_gb": 500
  },
  "notifications": {
    "email": ["admin@example.com"],
    "slack_webhook": "https://hooks.slack.com/services/XXXX/YYYY/ZZZZ"
  }
}
```

## Scheduling Backups

### Linux/Unix (Cron)

Add a cron job to run the backup script automatically:

```bash
# Run backup daily at 2 AM
0 2 * * * /path/to/python /path/to/cloud_backup.py --config=/path/to/backup_config.json
```

### Windows (Task Scheduler)

1. Open Task Scheduler
2. Create a new Basic Task
3. Set the trigger to run daily at your preferred time
4. Set the action to start a program
5. Program/script: `C:\Path\to\python.exe`
6. Arguments: `C:\Path\to\cloud_backup.py --config=C:\Path\to\backup_config.json`

## Best Practices

* Test the backup and restore process regularly

* Use strong encryption for sensitive data
* Store encryption keys securely and separately from the backups
* Implement the 3-2-1 backup strategy (3 copies, 2 different media, 1 offsite)
* Monitor backup logs and notifications
* Periodically verify backup integrity
* Automate cleanup of old backups to manage storage costs

## Support

For issues or questions about this tool, please contact <support@yourcompany.com> or open an issue on GitHub.

## License

MIT License - Feel free to modify and distribute this tool according to your needs.
